/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.h14199.command.dml.AllColumnsForPlan;
import org.h14199.engine.Mode;
import org.h14199.engine.Session;
import org.h14199.index.BaseIndex;
import org.h14199.index.Cursor;
import org.h14199.index.IndexType;
import org.h14199.index.NonUniqueHashCursor;
import org.h14199.index.SingleRowCursor;
import org.h14199.message.DbException;
import org.h14199.result.Row;
import org.h14199.result.SearchRow;
import org.h14199.result.SortOrder;
import org.h14199.table.Column;
import org.h14199.table.IndexColumn;
import org.h14199.table.PageStoreTable;
import org.h14199.table.TableFilter;
import org.h14199.value.DataType;
import org.h14199.value.Value;
import org.h14199.value.ValueNull;

public class HashIndex
extends BaseIndex {
    private final int indexColumn;
    private final boolean totalOrdering;
    private final PageStoreTable tableData;
    private Map<Value, Long> rows;
    private final ArrayList<Long> nullRows = new ArrayList();

    public HashIndex(PageStoreTable pageStoreTable, int n, String string, IndexColumn[] indexColumnArray, IndexType indexType) {
        super(pageStoreTable, n, string, indexColumnArray, indexType);
        Column column = indexColumnArray[0].column;
        this.indexColumn = column.getColumnId();
        this.totalOrdering = DataType.hasTotalOrdering(column.getType().getValueType());
        this.tableData = pageStoreTable;
        this.reset();
    }

    private void reset() {
        this.rows = this.totalOrdering ? new HashMap() : new TreeMap(this.database.getCompareMode());
    }

    @Override
    public void truncate(Session session) {
        this.reset();
    }

    @Override
    public void add(Session session, Row row) {
        Value value = row.getValue(this.indexColumn);
        if (value != ValueNull.INSTANCE || this.database.getMode().uniqueIndexNullsHandling == Mode.UniqueIndexNullsHandling.FORBID_ANY_DUPLICATES) {
            Long l = this.rows.get(value);
            if (l != null) {
                throw this.getDuplicateKeyException(value.toString());
            }
            this.rows.put(value, row.getKey());
        } else {
            this.nullRows.add(row.getKey());
        }
    }

    @Override
    public void remove(Session session, Row row) {
        Value value = row.getValue(this.indexColumn);
        if (value != ValueNull.INSTANCE || this.database.getMode().uniqueIndexNullsHandling == Mode.UniqueIndexNullsHandling.FORBID_ANY_DUPLICATES) {
            this.rows.remove(value);
        } else {
            this.nullRows.remove(row.getKey());
        }
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        if (searchRow == null || searchRow2 == null) {
            throw DbException.throwInternalError(searchRow + " " + searchRow2);
        }
        Value value = searchRow.getValue(this.indexColumn);
        if (value == ValueNull.INSTANCE && this.database.getMode().uniqueIndexNullsHandling != Mode.UniqueIndexNullsHandling.FORBID_ANY_DUPLICATES) {
            return new NonUniqueHashCursor(session, this.tableData, this.nullRows);
        }
        Long l = this.rows.get(value = value.convertTo(this.tableData.getColumn(this.indexColumn).getType(), this.database.getMode(), null));
        Row row = l == null ? null : this.tableData.getRow(session, l.intValue());
        return new SingleRowCursor(row);
    }

    @Override
    public long getRowCount(Session session) {
        return this.getRowCountApproximation();
    }

    @Override
    public long getRowCountApproximation() {
        return this.rows.size() + this.nullRows.size();
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void remove(Session session) {
    }

    @Override
    public double getCost(Session session, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, AllColumnsForPlan allColumnsForPlan) {
        for (Column column : this.columns) {
            int n2 = column.getColumnId();
            int n3 = nArray[n2];
            if ((n3 & 1) == 1) continue;
            return 9.223372036854776E18;
        }
        return 2.0;
    }

    @Override
    public void checkRename() {
    }

    @Override
    public boolean needRebuild() {
        return true;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        throw DbException.getUnsupportedException("HASH");
    }

    @Override
    public boolean canScan() {
        return false;
    }
}

